@extends('installer.layouts.app')

@section('content')
    <div class="doc-inner">
        <div class="doc-wrapper w-100">
            <h2 class="inner-title"><span>Product Key</span> Validation</h2>
            <form action="{{ route('project.install.validation.form.submit') }}" method="POST" class="doc-form mt-20">
                @csrf

                <div>
                    <p>
                        The product key is generated by <strong>AppDevs</strong> and is required to validate your purchase. Please enter the key in the field below.
                    </p>
                </div>

                <br/>

                <div class="form-group">
                    <label><strong>Enter Your Product Key</strong></label>
                    <input type="text" name="product_key" class="form--control" placeholder="Enter RANDOM value" required>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn--base w-100 mt-20">Verify the Key</button>
                </div>

                <p>
                    If you haven't generated a product key yet, <a href="https://appdevs.net/generate-product-key" target="_blank"><strong><span>click here to generate your product key.</span></strong></a>
                </p>
            </form>
        </div>
    </div>
@endsection