<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Gift Card Details'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__("Gift Card Details For")); ?> <?php echo e(@$data->trx_id); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form">
            <div class="row align-items-center mb-10-none">
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list-two">
                        <li class="one"><?php echo e(__("Date")); ?>: <span><?php echo e(@$data->created_at->format('d-m-y h:i:s A')); ?></span></li>
                        <li class="two"><?php echo e(__("receiver Email")); ?>: <span><?php echo e(@$data->details->card_info->recipient_email); ?></span></li>
                        <li class="three"><?php echo e(__("Receiver Phone")); ?>: <span>+<?php echo e(@$data->details->card_info->recipient_phone); ?> </span></li>
                        <li class="four"><?php echo e(__("Full Name")); ?>: <span>
                            <?php if($data->user_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.users.details',$data->user->username)); ?>"><?php echo e($data->user->fullname); ?> (<?php echo e(__("USER")); ?>)</a>
                            <?php endif; ?>
                            </span></li>

                        <li class="five"><?php echo e(__("Payable Unit Price")); ?>: <span><?php echo e(get_amount(@$data->details->charge_info->sender_unit_price,@$data->details->charge_info->wallet_currency)); ?></span></li>


                    </ul>
                </div>

                <div class="col-xl-4 col-lg-4 form-group">
                    <div class="user-profile-thumb">
                        <img src="<?php echo e(get_image($data->user->userImage)); ?>" alt="payment">
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list two">
                        <li class="one"><?php echo e(__("Exchange Rate")); ?>: <span><?php echo e(get_amount(1,@$data->details->charge_info->card_currency) ." = ". get_amount(@$data->details->charge_info->exchange_rate,@$data->details->charge_info->wallet_currency)); ?></span></li>
                        <li class="two"><?php echo e(__("Card Quantity")); ?>: <span><?php echo e(@$data->details->charge_info->qty); ?></span></li>
                        <li class="three"><?php echo e(__("Total Charge")); ?>: <span><?php echo e(get_amount(@$data->charge->total_charge,@$data->details->charge_info->wallet_currency)); ?></span></li>
                        <li class="four"><?php echo e(__("Payable Amount")); ?>: <span><?php echo e(get_amount(@$data->payable,@$data->details->charge_info->wallet_currency)); ?></span></li>
                        <li class="five"><?php echo e(__("Status")); ?>:  <span class="<?php echo e(@$data->stringStatus->class); ?>"><?php echo e(__(@$data->stringStatus->value)); ?></span></li>
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__("Gift Card Information")); ?> </h6>
    </div>
    <div class="card-body">
        <form class="card-form">
            <div class="row align-items-center mb-10-none">
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list-two">
                        <li class="one"><?php echo e(__("Card Name")); ?>: <span><?php echo e(@$data->details->card_info->card_name); ?></span></li>
                        <li class="two"><?php echo e(__("Card Currency")); ?>: <span><?php echo e(@$data->details->card_info->card_currency); ?></span></li>
                        <li class="three"><?php echo e(__("Card Unit Price")); ?>: <span><?php echo e(get_amount(@$data->details->charge_info->card_unit_price,@$data->details->charge_info->card_currency)); ?></span></li>
                        <li class="four"><?php echo e(__("Card Total Price")); ?>: <span><?php echo e(get_amount(@$data->details->charge_info->total_receiver_amount,@$data->details->charge_info->card_currency)); ?> </span></li>
                        <li class="five"><?php echo e(__("Card Api Currency")); ?>: <span><?php echo e(@$data->details->card_info->api_currency); ?> </span></li>
                    </ul>
                </div>

                <div class="col-xl-4 col-lg-4 form-group">
                    <div class="user-profile-thumb">
                        <img src="<?php echo e(@$data->details->card_info->card_image); ?>" alt="payment">
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list two">
                        <li class="one"><?php echo e(__("Api Discount")); ?>: <span><?php echo e(get_amount(@$data->details->card_info->api_discount,@$data->details->card_info->api_currency)); ?></span></li>
                        <li class="two"><?php echo e(__("Api Fee")); ?>: <span><?php echo e(get_amount(@$data->details->card_info->api_fee,@$data->details->card_info->api_currency)); ?></span></li>
                        <li class="three"><?php echo e(__("Api Sms Fee")); ?>: <span><?php echo e(get_amount(@$data->details->card_info->api_sms_fee,@$data->details->card_info->api_currency)); ?></span></li>
                        <li class="four"><?php echo e(__("Api Total Fee")); ?>: <span><?php echo e(get_amount(@$data->details->card_info->api_total_fee,@$data->details->card_info->api_currency)); ?></span></li>
                        <li class="five"><?php echo e(__("Api Trx Id")); ?>: <span><?php echo e(@$data->details->card_info->api_trx_id); ?></span></li>
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>




<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/admin/sections/gift-card/details.blade.php ENDPATH**/ ?>