<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="table-area">
    <div class="table-wrapper">
        <div class="table-header">
            <h5 class="title"><?php echo e($page_title); ?></h5>
            <?php if(count($profits) > 0): ?>
            <div class="table-btn-area">
                <h5 class="title"><?php echo e(__("Total Profits")); ?>: <?php echo e(getAmount(totalAdminProfits(),3)); ?> <?php echo e(get_default_currency_code()); ?></h5>
            </div>
        <?php endif; ?>
        </div>
        <div class="table-responsive">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__("TRX ID")); ?></th>
                        <th><?php echo e(__("User")); ?></th>
                        <th><?php echo e(__("Transaction Type")); ?></th>
                        <th><?php echo e(__("Profit Amount")); ?></th>
                        <th><?php echo e(__("Time")); ?></th>

                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $profits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(@$item->transactions->trx_id); ?></td>
                            <td>
                                <a href="<?php echo e(setRoute('admin.users.details',@$item->transactions->creator->username)); ?>"><?php echo e(@$item->transactions->creator->fullname); ?></a>
                            </td>
                            <td><?php echo e(@$item->transactions->type); ?></td>
                            <td><?php echo e(number_format(@$item->total_charge,2)); ?> <?php echo e(get_default_currency_code()); ?></td>
                            <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>

                        </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                         <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 6], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e(get_paginate($profits)); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/admin/sections/profits/index.blade.php ENDPATH**/ ?>