<table class="custom-table transaction-search-table">
    <thead>
        <tr>
            <th><?php echo e(__("TRX ID")); ?></th>
            <th><?php echo e(__("User")); ?></th>
            <th><?php echo e(__("Card Name")); ?></th>
            <th><?php echo e(__("Card Images")); ?></th>
            <th><?php echo e(__("receiver Email")); ?></th>
            <th><?php echo e(__("Receiver Phone")); ?></th>
            <th><?php echo e(__("Payable Unit Price")); ?></th>
            <th><?php echo e(__("Total Charge")); ?></th>
            <th><?php echo e(__("Payable Amount")); ?></th>
            <th><?php echo e(__("Time")); ?></th>
            <th><?php echo e(__("Status")); ?></th>
            <th><?php echo e(__("Action")); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><?php echo e($item->trx_id); ?></td>
            <td>
                <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>"><span class="text-info"><?php echo e($item->user->fullname); ?></span></a>
            </td>
            <td><?php echo e($item->details->card_info->card_name); ?></td>
            <td><img style="max-width: 50px" src="<?php echo e($item->details->card_info->card_image); ?> " alt=""></td>
            <td><?php echo e($item->details->card_info->recipient_email); ?></td>
            <td>+<?php echo e($item->details->card_info->recipient_phone); ?></td>
            <td><?php echo e(get_amount($item->details->charge_info->sender_unit_price,$item->details->charge_info->wallet_currency)); ?></td>
            <td><?php echo e(get_amount($item->charge->total_charge,$item->details->charge_info->wallet_currency)); ?></td>
            <td><?php echo e(get_amount($item->payable,$item->details->charge_info->wallet_currency)); ?></td>
            <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>
            <td><span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?> </span></td>
            <td>
                <?php echo $__env->make('admin.components.link.info-default',[
                    'href'          => setRoute('admin.gift.card.details', $item->id),
                    'permission'    => "admin.gift.card.details",
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

        <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 15], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/admin/components/data-table/gift-card-transaction-log.blade.php ENDPATH**/ ?>