<?php $__env->startPush('css'); ?>
    <style>
        .fileholder {
            min-height: 280px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 246px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Admin Profile")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("2FA Settings")); ?></h6>
        </div>

        <div class="card-body">

            <div class="text-center">
                <div class="img-box twofa-qr-code">
                    <img src="<?php echo e($qr_code); ?>" alt="qr-code">
                </div>

                <div class="secret-key mt-3">
                    <span class="fw-bold"  id="referralURL"><?php echo e(auth()->user()->two_factor_secret); ?></span>
                    <div class="copy-text copy-btn copytext" data-copy-text="<?php echo e(auth()->user()->two_factor_secret); ?>"><i class="las la-copy"></i></div>
                </div>
            </div>

            <?php if(auth()->user()->two_factor_status): ?>
                <button type="button" class="mt-3 btn--base bg-warning w-100 active-deactive-btn" data-confirm-btn-text="<?php echo e(__("Disable")); ?>"><?php echo e(__("Disable Two Factor Authenticator")); ?></button>
                <br>
                <div class="text--danger mt-3 text-center fs-6"><?php echo e(__("Don't forget to add this application in your google authentication app. Otherwise you can't login in your account.")); ?></div>
            <?php else: ?>
                <button type="button" class="mt-3 btn--base w-100 active-deactive-btn" data-confirm-btn-text="<?php echo e(__("Enable")); ?>"><?php echo e(__("Enable Two Factor Authenticator")); ?></button>
            <?php endif; ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(".active-deactive-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('admin.profile.google.2fa.status.update')); ?>";
            var target      = "<?php echo e(auth()->user()->id); ?>";
            var btnText     = $(this).attr("data-confirm-btn-text");
            var sureText = '<?php echo e(__("Are you sure to")); ?>';
            var lastText = '<?php echo e(__("2 factor authentication (Powered by google)")); ?>';
            var message     = `${sureText} <strong>${btnText}</strong> ${lastText}?`;
            openDeleteModal(actionRoute,target,message,btnText,"POST");
        });
        $('.copytext').on('click',function(){
            var copyText = document.getElementById("referralURL");
            var range = document.createRange();
            range.selectNode(copyText);
            window.getSelection().removeAllRanges();
            window.getSelection().addRange(range);
            document.execCommand("copy");
            window.getSelection().removeAllRanges();

            throwMessage('success',["<?php echo e(__('Copied')); ?>: " + copyText.textContent]);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/admin/sections/profile/2fa/google.blade.php ENDPATH**/ ?>